<?php
class Zsam_Form_Simple extends Zsam_Form {

    private $table_class = null;

    public function setRequiredPasswords($bool) {

        foreach ($this->_elements as $key => $value) {
            if ($this->_elements [$key]->getType() == "Zend_Form_Element_Password")
                $this->_elements [$key]->setRequired($bool);
        }
    }

    public function populate(array $values) {
        $table_class = $this->table_class;
        $table = new $table_class ();
        $fields = $table->getDescribe();
        foreach ($fields as $key => $f) {
            if (@$values [$key] != null && @$values [$key] != '') {
                if ($f ['DATA_TYPE'] == 'date')
                    $values [$key] = Zsam_Util::date($values [$key]);
                if ($f ['DATA_TYPE'] == 'double')
                    $values [$key] = Zend_Locale_Format::toFloat($values [$key]);
            }
        }
        parent::populate($values);
    }

    public function __construct($table_class, $deps = array(), $groups = array(), $ajax = true, $viewscript = null, $defaultValues = null, $id_table = '', $post = null) {
    	parent::__construct();


        $this->table_class = $table_class;
        $this->setMethod('post');

        if ($viewscript != null) {

            $this->setDisableLoadDefaultDecorators(true);

            $this->setDecorators(array(array('ViewScript', array('viewScript' => $viewscript)), 'Form'));
        }
        $table = new $table_class();

        $fields = $table->getDescribe();
        
        $refs = $table->info('referenceMap');
        $array = array();
        
        foreach ($fields as $id => $f) {
			
        	if (@$f ['edit'] == 'N') {
            	
					if(isset($refs [$f ['COLUMN_NAME']])){
						
						@$el = new Zsam_Form_Elements_Autocomplet($id);
						@$el->setAttrib('table', $refs [$f ['COLUMN_NAME']] ['refTableClass']);
						$el->setAttrib('readOnly', true);
					
					} else{
						
							$el = new Zend_Form_Element_Text($id);
							
							if (@$f ['DATE'] == 'Y' || $f ['DATA_TYPE'] == 'date'){
								$el->setAttrib('readonly', true);
							}else $el->setAttrib('readonly', true);
					}
				
			}elseif(@$f ['editlevel'] > Zsam_User::getLevel()){
			
					if (@$f['type'] != 'upload'){
						$el = new Zend_Form_Element_Text($id);
						$el->setAttrib('readOnly', 'readonly');
					
					}else{
						$el = new Zsam_Form_Elements_Image($id);
						$el->addDecorator('ViewHelper');
						$el->setAttribs(array('width'=>$f ['size']));
						$el->setAttrib('readOnly', 'readonly');
					}
					
              }elseif (@$f ['type'] == 'password') {

              		$el = new Zend_Form_Element_Password($id);
              
              }elseif (@$f ['type'] == 'upload') {
                        
              			$this->setAttrib('enctype', 'multipart/form-data');
                        $el = new Zsam_Form_Elements_Image($id);
                        $el->addDecorator('ViewHelper');
                        $el->setAttribs(array('width'=>@$f ['size']));
                        
               }elseif (@$f ['type'] == 'xmlView'){
                     	
               		$el = new Zsam_Form_Elements_XmlView($id);
                     	
               }elseif (isset($refs [$f ['COLUMN_NAME']])) {
                        
               		if(!is_array($refs [$f ['COLUMN_NAME']] ['refTableClass'])){
                           	
               				if (@$f['type'] == 'itemGrid') {
				                
               					$el = new Zsam_Form_Elements_ElementItemGrid($id);
				                // passar como outro atributo
				                $el->setAttrib('model', @$refs [$f ['COLUMN_NAME']] ['refTableClass']);
								$el->setAttrib('idWhere', @$f['idWhere']);
        						$el->setAttrib('valueWhere', @$f['valueWhere']);
        						$el->setAttrib('columns', @$f['columns']);
        						$el->setAttrib('buttons', @$f['buttons']);
        						$el->setAttrib('order_item', @$f['order_item']);
        						$el->setAttrib('restrict', @$f['restrict']);
        						$el->setAttrib('controller', @$f['controller']);
                           
        					}elseif (@$f['type'] == 'itemGridAuto'){	
        						
        						$el = new Zsam_Form_Elements_ElementItemGridAuto($id);
        						// passar como outro atributo
        						$el->setAttrib('model', @$refs [$f ['COLUMN_NAME']] ['refTableClass']);
        						$el->setAttrib('idWhere', @$f['idWhere']);
        						$el->setAttrib('idWhereai', @$f['idWhereai']);
        						$el->setAttrib('configitem', @$f['configitem']);
        						$el->setAttrib('valueWhere', @$f['valueWhere']);
        						$el->setAttrib('columns', @$f['columns']);
        						$el->setAttrib('buttons', @$f['buttons']);
        						$el->setAttrib('order_item', @$f['order_item']);
        						$el->setAttrib('restrict', @$f['restrict']);
        						$el->setAttrib('controller', @$f['controller']);
        						
        						
               				}elseif (@$f['type'] == 'aprovacaoedi'){	
        						
               					$el = new Zsam_Form_Elements_AprovacaoEdi($id);
               					$el->setAttrib('tipo', @$f['tipo']);
        						
        						
               				}elseif (@$f['type'] == 'folhaaprovar'){	
        						
               					$el = new Zsam_Form_Elements_FolhaAprovar($id);
               					$el->setAttrib('banco', $id);
               					$el->setAttrib('tipo', @$f['tipo']);
        						
        						
               				}elseif (@$f['type'] == 'boletoemail'){	
        						
               					$el = new Zsam_Form_Elements_Boletoemail($id);
               					//$el->setAttrib('banco', $id);
               					//$el->setAttrib('tipo', @$f['tipo']);
        						
        						
               				}elseif (@$f['type'] == 'checkbox'){
	                           	
               					$el = new Zend_Form_Element_MultiCheckbox($id);
	                           	$table_consulta = new $refs [$f ['COLUMN_NAME']] ['refTableClass']();
	                           	$key            = $refs [$f ['COLUMN_NAME']] ['refColumns'];
	                           	$keys =$table->selectcheckbox($refs [$f ['COLUMN_NAME']] ['refTableClass'],$f);

	                           	foreach ($keys as $reg){

	                           			$el->addMultiOption($reg[$key],$table_consulta->printTitle($reg));
	                           	}

	                           	$el->addPrefixPath('Cisweb_Util',
							                           			'Cisweb/Util/',
							                           			'decorator');

	                           	$el->setDecorators(array('FormElements', array('decorator',array('options'=>$f))));

                           }elseif (@$f['type'] == 'comparativo'){
                           	
	                           	$el = new Zend_Form_Element_Text($id);
	                           	$table_consulta = new $refs [$f ['COLUMN_NAME']] ['refTableClass']();
	                           	$key            = $refs [$f ['COLUMN_NAME']] ['refColumns'];
	                           	$keys =$table->dados_mapa($refs [$f ['COLUMN_NAME']] ['refTableClass'],$f);
	                           	
	                           	$el->addPrefixPath('Cisweb_Util',
							                           			'Cisweb/Util/',
							                           			'decorator');
	                           	$el->setDecorators(array('FormElements', array('comparativo',array('options'=>$f,'row'=>$keys))));
                           
                           }elseif (@$f['type'] == 'cotacao'){

                           		$el = new Zend_Form_Element_Text($id);

                           		$table_consulta = new $refs [$f ['COLUMN_NAME']] ['refTableClass']();
                           		$key            = $refs [$f ['COLUMN_NAME']] ['refColumns'];
	                           	//$keys           = $table_consulta->fetchAll($select);
	
	                           	$keys =$table->dados_mapa($refs [$f ['COLUMN_NAME']] ['refTableClass'],$f);
	
	                           	$el->addPrefixPath('Cisweb_Util',
	                           			'Cisweb/Util/',
	                           			'decorator');
	
	                           	$el->setDecorators(array('FormElements', array('cotacao',array('options'=>$f,'row'=>$keys))));

                           }elseif (@$f['type'] == 'cotacaoanexo'){

	                           	$el = new Zend_Form_Element_MultiCheckbox($id);
	
	                           	$table_consulta = new $refs [$f ['COLUMN_NAME']] ['refTableClass']();
	                           	$key            = $refs [$f ['COLUMN_NAME']] ['refColumns'];
	
	                           	//$complete       = $table_consulta->_autocomplet;
	
	                           	$keys =$table->selectcheckbox($refs [$f ['COLUMN_NAME']] ['refTableClass'],$f);
	
	                           	foreach ($keys as $k2 => $reg)
	                           	{
	                           		$el->addMultiOption($reg[$key],$table_consulta->printTitle($reg));
	                           	}
	
	                           	$el->addPrefixPath('Cisweb_Util',
							                           			'Cisweb/Util/',
							                           			'decorator');
	
	                           	$el->setDecorators(array('FormElements', array('decoratoranexo',array('options'=>$f,'dados'=>$keys))));
                           
                           }else {
                                
                           		if (@$f ['autocomplete'] == 'Y') {
                                    $el = new Zsam_Form_Elements_Autocomplet($id);
                                    $el->setAttrib('table', $refs [$f ['COLUMN_NAME']] ['refTableClass']);
									//$el->setAttrib('restrict', @$refs [$f ['COLUMN_NAME']] ['restrict']);
                                }else {
                                    $el = new Zsam_Form_Elements_Combo($id, null, $refs [$f ['COLUMN_NAME']] ['refTableClass'],@$f['RESTRICT_MAP'], null, @$f['ORDER'],@$f['TRANSLATE'],  $refs [$f ['COLUMN_NAME']] ['refColumns']);
                                }
                                
                                $tmp = new $refs [$f ['COLUMN_NAME']] ['refTableClass'] ();

                                $el->addValidator(new Zend_Validate_Db_RecordExists($tmp->getName(), $refs [$f ['COLUMN_NAME']] ['refColumns']));

                                if(isset($refs [$f ['COLUMN_NAME']] ['semChave'])){
                                    $el->setRegisterInArrayValidator(FALSE);
                                }
                            }
                        }
                     
               		}elseif (isset($f ['VP'])) {
                        $el = new Zend_Form_Element_Select($id);
                        $el->addMultiOption('');
                        $el->setRegisterInArrayValidator(FALSE);

                        if (is_array($f ['VP'])) {

                        	foreach ($f ['VP'] as $k => $v) {
                                $el->addMultiOption($k, $v);
                            }
                        } else {
                            
                        	$opts = explode(',', $f ['VP']);
                            
                            foreach ($opts as $k => $v) {
                                $el->addMultiOption($v, $v);
                            }
                        }
                        
                    }elseif ($f ['DATA_TYPE'] == 'text') {
                        $el = new Zend_Form_Element_Textarea($id);
 //                       $el->addFilter(new Zend_Filter_Alnum(array('allowwhitespace'=>true))); //alterado CIS-ERP 20/05/2014 mudado de == para != Tiago e Reinaldo
                        if (@$f ['RTE'] == "Y")
                            $el->setAttrib('rte', 'basic');

					}else {
                        $el = new Zend_Form_Element_Text($id);
                    }
					//aqui já foi criado o elemento input 
                    /**
                     * Adiciona um tooltip para cada elemento do formulário
                     * Para isso, use: 'alt' => 'valor para o texto' no Model
                     * @author Edgar R. Sandí
                     * @task 115
                     */
                    if (isset($f ['alt'])) {
                        $translate = Zend_Registry::get('Zend_Translate');
                        $alt = $translate->_($f ['alt']);

                        $el->setAttrib('class', 'qtip-borderBottom');
                        $el->setAttrib('title', $alt);
                    }

                    /**
                     * Adiciona uma linha abaixo do título de cada label
                     * Para isso, use: 'help' => 'valor para o texto' no Model
                     * @author Edgar R. Sandí
                     * @task 115
                     *
                     */
                    if (isset($f ['help'])) {
                        $el->addDecorator('Label', array('escape' => false));

                        $translate = Zend_Registry::get('Zend_Translate');
                        $help = $translate->_($f ['help']);
                        if (isset($f ['title'])) {
                            $title = $translate->_($f ['title']);
                            $el->setLabel($title . '<br/><span class="help">' . $help . '</span>');
                        } else {
                            $column = $translate->_($f ['COLUMN_NAME']);
                            $el->setLabel($column . '<br/><span class="help">' . $help . '</span>');
                        }
                    } else {
//                        $el->addDecorator('Label', array('escape' => false));
                        if (isset($f ['title']))
                            $el->setLabel($f ['title']);
                        else
                            $el->setLabel($f ['COLUMN_NAME']);
                    }

					if (isset($f ['NULLABLE']) && $f ['NULLABLE'] == false) {
                        //print_r($f ['COLUMN_NAME']);
						$el->addDecorator('Label', array('escape' => false));

                        $translate = Zend_Registry::get('Zend_Translate');
                        $help = $translate->_('campo_obrigatorio');
                        if (isset($f ['title'])) {
                            $title = $translate->_($f ['title']);
                            $el->setLabel($title . '<br/><span class="obrigatorio">' . $help . '</span>');
                        } else {
                            $column = $translate->_($f ['COLUMN_NAME']);
                            $el->setLabel($column . '<br/><span class="obrigatorio">' . $help . '</span>');
                        }
					}

					if (isset($f ['help']) && isset($f ['NULLABLE']) && $f ['NULLABLE'] == false) {
                        $el->addDecorator('Label', array('escape' => false));

                        $translate = Zend_Registry::get('Zend_Translate');
                        $help = $translate->_($f ['help']);
                        if (isset($f ['title'])) {
                            $title = $translate->_($f ['title']);
                            $el->setLabel($title . '<br/><span class="obrigatorio">' . $translate->_('campo_obrigatorio') . '</span><br/><span class="help">' . $help . '</span>');
                        } else {
                            $column = $translate->_($f ['COLUMN_NAME']);
                            $el->setLabel($column . '<br/><span class="obrigatorio">' . $translate->_('campo_obrigatorio') . '</span><br/><span class="help">' . $help . '</span>');
                        }
					}


                    if (@$f ['DEFAULT'] != null)
                        $el->setValue($f ['DEFAULT']);

                                        if(isset($_SESSION['item']['defaultValues'])){
                    	foreach ($_SESSION['item']['defaultValues'] as $k => $v){
                    		if($k == $id){
                    			 $el->setValue($v);
                    		}
                    	}
                    }

                    if ($f ['NULLABLE'] == false && !$f ['IDENTITY']) {
                        //$el->setAttrib('class', 'teste');
                        $el->setRequired(true);

                    }

                    if (stripos($f ['DATA_TYPE'], 'int') !== false) {
                        //$el->addFilter('Int');
                        $el->addValidator(new Zend_Validate_Int());
                    }



                    if ($f ['DATA_TYPE'] == 'double') {
                        $el->addValidator(new Zend_Validate_Float());


                    }
                    if ($f ['DATA_TYPE'] == 'varchar' || $f ['DATA_TYPE'] == 'char') {
                        $el->addFilter('StripTags');
                        $el->addFilter('StringTrim');

                        if (@$f['char_spec'] != 'NONE'){
                            $el->addFilter(new Zsam_Filter_RemoveSpecialChar()); //alterado CIS-ERP 20/04/2012 mudado de == para !=
                        }

                        /**
                         * @name Task # 117 //
                         * @author Edgar R. Sandí
                         * alteração realizada para incluir uma excessão de UPPER
                         * No caso por exemplo de cadastro de um usuário
                         * Adicionado no Zsam_Util uma variavel que determina o case padrão da aplicação
                         */
                        $f ['case'] = (@$f ['case'] == '') ? Zsam_Util::getDefaultCase() : $f ['case'];
                        if ($f ['case'] == 'UPPER') {
                            $el->addFilter(new Zend_Filter_StringToUpper());
                        } elseif ($f ['case'] == 'LOWER') {
                            $el->addFilter(new Zend_Filter_StringToLower());
                        }

                        $el->addValidator('stringLength', false, array(0, $f ['LENGTH']));

                        if ($el->getType() == 'Zend_Form_Element_Text') {
                            if ($f ['LENGTH'] > 48)
                                $el->setAttrib("size", 50);
                            else
                                $el->setAttrib("size", $f ['LENGTH'] + 2);

                            $el->setAttrib("maxlength", $f ['LENGTH']);
                        }
                        if (isset($f ['MASK'])) {
                            $el->setAttrib("mask", "Y");
                            $el->setAttrib("mask_rule", $f ['MASK']);
                        }
                    }
                    if (@$f ['DATE'] == 'Y' || $f ['DATA_TYPE'] == 'date') {

                       	if (@$f ['edit'] != 'N')$el->setAttrib("zsam", "date");// alterado cis-erp
                        $el->setAttrib("MASK", "Y");
                        $el->setAttrib("MASK_RULE", "99/99/9999");
                    }

                    if ($f ['DATA_TYPE'] == 'time') {

                        $el->setAttrib("MASK", "Y");
                        $el->setAttrib("MASK_RULE", "99:99");
                    }

                 	if (@$f['DATA_TYPE']== 'double(16,8)')// cis-erp para nao colocar virgula e ponto simultaneamente
                 	{
                        $el->setAttrib("MASKPONTOEVIRGULA", "Y");
                    }// cis-erp

                 	if ((@$f['DATA_TYPE']== 'double(13,2)'|| @$f['DATA_TYPE']== 'double(8,2)'|| @$f['DATA_TYPE']== 'double(6,2)') && @$f['edit'] != 'N')// cis-erp
                 	{
                        $el->setAttrib("MASKDOUBLE", "Y");
                    }// cis-erp

                    if (@$f['DATA_TYPE']== 'double(8,3)'|| @$f['DATA_TYPE']== 'double(6,3)')// cis-erp
                 	{
                 		$el->setAttrib("MASKPONTOEVIRGULA", "Y");
                    }// cis-erp

                    if (isset($f ['validate'])) {
                        if (is_array($f ['validate'])) {
                            foreach ($f ['validate'] as $key => $value) {

                                if (is_array($value)) {
                                    $validador = new $key($value);
                                } else {
                                    $validador = new $value ();
                                }
                                $el->addValidator($validador);
                            }
                        } else {
                            $list = explode(',', $f ['validate']);
                            foreach ($list as $value) {
                                $validador = new $value ();
                                $el->addValidator($validador);
                            }
                        }
                    }
                    if (@$f ['type'] == 'ComboMultiTables') {

                        if(isset($refs [$f ['COLUMN_NAME']] ['refTableClass']) AND is_array($refs [$f ['COLUMN_NAME']] ['refTableClass'])){
                           $el = new Zsam_Form_Elements_ComboMultiTables($id);
                           $el->setAttribs(array($refs [$f ['COLUMN_NAME']] ['refTableClass']));

                        }
                    }

                    //verifica array do post (se o campo não foi adicionado ao formulário, ele não é adicionado a lista)
                    //if ( (!empty($post) && !array_key_exists($id,$post)) && (strpos($id,'GRID') === false && empty($post))) {
                    if ( (!empty($post) && !array_key_exists($id,$post)) && (strpos($id,'GRID') === false )) {
                        continue;
                    }

                    if (isset($f ['level'])) {
                        if (Zsam_User::getLevel() >= $f ['level']) {
                            $array [] = $el;
                        }
                    } else {
                        $array [] = $el;
                    }
            }
                foreach ($deps as $dep) {
                    if ($dep ['type'] == 'NxN') {

                        $el = new Zsam_Form_Elements_NxN($dep ['table']);

                        $min = null;
                        if (@$dep ['min'] > 0) {
                            $min = $dep ['min'];
                            $el->setRequired(true);
                        }
                        $max = null;
                        if (@$dep ['max'] > 0)
                            $min = $dep ['max'];

                        $el->setAttrib('table', $dep ['table']);
                        $el->setAttrib('table_orig', $table_class);
                        $el->addValidator('Nxn', false, array($min, $max));
                    } elseif ($dep ['type'] == 'multicheck') {

                        $el = new Zsam_Form_Elements_Multicheckbox($dep ['table'], null, $dep ['table'], $table_class, $dep ['restrict']);

                        if (@$dep ['min'] > 0) {
                            $min = $dep ['min'];
                            $el->setRequired(true);
                        }
                    }

                    /*elseif ($dep ['type'] == 'checkbox') {

                    	//foreach ($dep[0] as $keycheck => $valuecheck)
                    	//{
                    		$el = new Zsam_Form_Elements_Checkbox($dep['table'], null, $dep['table'], $table_class);
                    		//$el = new Zsam_Form_Elements_Checkbox($dep['table2'], null, $dep['table2'], $table_class);
                    		/*if (@$dep ['min'] > 0) {
                    			$min = $dep ['min'];
                    			$el->setRequired(true);
                    		}*/
                    	//}

                    //}

                    if (@$dep ['label'] == '')
                        $el->setLabel($table_class . '_' . $dep ['table']);
                    else
                        $el->setLabel($dep ['label']);


                }

                if (!$ajax) {
                    $submit = new Zend_Form_Element_Submit('submit');
                    $submit->setAttrib('id', 'submitbutton');
                    $submit->setLabel('save');
                    $array [] = $submit;
                }

                $array[] = $el; 
                $this->addElements($array);

                if (count($groups) > 0) {
                    $h = 0;
                    foreach ($groups as $name => $group) {

                        $decor = array('FormElements', array('HtmlTag', array('tag' => 'div', 'class' => 'zsam_form_group', 'id' => 'group' . $h, 'title' => $name)));
                        $v = explode(',', $group);
                        $h++;
                        
                        $this->addDisplayGroup($v, 'group' . $h, array('decorators' => $decor));

                        //array('displayGroupClass' => 'My_DisplayGroup')
                    }
                }
                // die();

                // Zend_Debug::dump($this->getElements()); die();
            }

    public function init() {

        parent::init();
    }



}

?>
